/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.fabric.ui.containers;

import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.page.GooeyPage;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.ui.containers.Icon;
import net.impactdev.impactor.api.ui.containers.views.pagination.Pagination;
import net.impactdev.impactor.fabric.ui.gooey.GooeyIcon;
import net.impactdev.impactor.fabric.ui.gooey.GooeyPageOpenCloser;
import net.impactdev.impactor.minecraft.api.items.AdventureTranslator;
import net.impactdev.impactor.minecraft.api.items.ServerProvider;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.pagination.views.ImpactorPagination;
import org.jetbrains.annotations.Nullable;

public final class FabricPaginationView
extends ImpactorPagination
implements GooeyPageOpenCloser {
    private final ChestTemplate template;
    private final GooeyPage delegate;

    private FabricPaginationView(ImpactorPagination.ImpactorPaginationBuilder builder) {
        super(builder);
        ChestTemplate.Builder template = ChestTemplate.builder((int)this.rows());
        this.layout().elements().forEach((slot, icon) -> template.set(slot.intValue(), (Button)new GooeyIcon((Icon)icon)));
        this.pages().current().icons().forEach((slot, icon) -> template.set(slot.intValue(), (Button)new GooeyIcon((Icon)icon)));
        AdventureTranslator.Server translator = AdventureTranslator.Server.get(ServerProvider.server());
        this.template = template.build();
        this.delegate = GooeyPage.builder().template((Template)this.template).title(translator.asNative(this.title())).build();
    }

    @Override
    public void set(@Nullable Icon icon, int slot) {
        this.template.set(slot, (Button)Optional.ofNullable(icon).map(GooeyIcon::new).orElse(null));
    }

    @Override
    public void open(PlatformPlayer viewer) {
        super.open(this.viewer);
        this.openPage(this.delegate, this.viewer);
    }

    @Override
    public void close(PlatformPlayer viewer) {
        super.close(viewer);
        this.closePage(this.viewer);
    }

    public static final class FabricPaginationViewBuilder
    extends ImpactorPagination.ImpactorPaginationBuilder {
        @Override
        public Pagination build() {
            Preconditions.checkNotNull((Object)this.namespace, (Object)"Provider was not specified");
            Preconditions.checkNotNull((Object)this.viewer, (Object)"Viewer was not specified");
            if (this.contents == null) {
                this.contents = Collections.emptyList();
            }
            return new FabricPaginationView(this);
        }
    }
}

